/****************************************************************************************/
/*                                                                                      */
/* Name       : TCI_232.H            Version: 001.020215go                              */
/*                                                                                      */
/* Author     : Gerhard Ort                                                             */
/*                                                                                      */
/* Language   : C                                                                       */
/*                                                                                      */
/* Description: Include for Communication Interface RS232                               */
/*                                                                                      */
/****************************************************************************************/
/*                                                                                      */
/* 14.05.99 V001 Gerhard Ort File created                                               */
/*                                                                                      */
/****************************************************************************************/

/*--------------------------------------------------------------------------------------*/
/* include control                                                                      */
/*--------------------------------------------------------------------------------------*/
#ifndef __INC_HW_Interface_RS232
#define __INC_HW_Interface_RS232


/****************************************************************************************/
/*  Exports                                                                             */
/****************************************************************************************/

/****************************************************************************************/
/*                                                                                      */
/* Function   : fSerialInit()                                                           */
/*                                                                                      */
/* Description: inits the RS232 communication                                           */
/*                                                                                      */
/* Return     : 0 = no errror                                                           */
/*              1 = communication error                                                 */
/*                                                                                      */
/****************************************************************************************/
unsigned short fSerialInit
(
  char  *pcParm     // IMP: parameter string (not used)
);

/****************************************************************************************/
/*                                                                                      */
/* Function   : fSerialChange()                                                         */
/*                                                                                      */
/* Description: changes the communication parameter, adjusted by fSerialInit()          */
/*                                                                                      */
/* Return     : 0: no error                                                             */
/*                                                                                      */
/****************************************************************************************/
unsigned short fSerialChange(void);

/****************************************************************************************/
/*                                                                                      */
/* Function   : fSerialSendStr()                                                        */
/*                                                                                      */
/* Description: sends a string to the PC/Testsystem via serial interface (RS232)        */
/*              For this transmit direction no software handshake is done.              */
/*                                                                                      */
/* Return     : 0 = no errror                                                           */
/*              COM_ERR = got NULL-Pointer or String too long, only sent first          */
/*              COM_STRLEN_MAX characters                                               */
/*                                                                                      */
/****************************************************************************************/
unsigned short fSerialSendStr
(
  char *pc          // IMP: string to be send over the RS232
);

/****************************************************************************************/
/*                                                                                      */
/* Function   : fSerialPureSend()                                                       */
/*                                                                                      */
/* Description: sends a string to the PC/Testsystem via serial interface (RS232)        */
/*              For this transmit direction no software handshake is done.              */
/*              Distinction to fSerialSendStr: no RETURN is added                       */
/*                                                                                      */
/* Return     : 0 = no errror                                                           */
/*              COM_ERR = got NULL-Pointer or String too long, only sent first          */
/*              COM_STRLEN_MAX characters                                               */
/*                                                                                      */
/****************************************************************************************/
unsigned short fSerialPureSend
(
  char *pc            // IMP: string to be send over the RS232
);
char fSerial_putKey(char);



/****************************************************************************************/
/*                                                                                      */
/* Function   : fSerialReceiveStr()                                                     */
/*                                                                                      */
/* Description: reads a command string from the RS232. This function does not return    */
/*              control until a string is received.                                     */
/*              Each command string has to be terminated with END_OF_SERIAL_STRING      */
/*              To make sure no data are lost the transmitter (=testsytem, terminal)    */
/*              there is a simple handshake. The transmitter has to wait for this echo  */
/*              before sending an new charakter.                                        */
/*                                                                                      */
/* Return     : 0 = no errror                                                           */
/*              1 = communication error                                                 */
/*                                                                                      */
/****************************************************************************************/
unsigned short fSerialReceiveStr
(
  char *pc          // EXP: string buffer in which the received string is stored (max 80)
);

/***********************************************************************/
/*                                                                     */
/* Function   : fSerial_putchar()                                      */
/*                                                                     */
/* Description: transmits a character using ASC0, the serial port      */
/*              '\n'-Character is changed to '\r' (for Terminal-Program*/
/*                                                                     */
/* Return     : character which should be transmitted                  */
/*                                                                     */
/***********************************************************************/
char fSerial_putchar
(
  char c            // IMP: character to send
);
#endif
