/*************************************************************************/
/*                                             Version in project: 1.00  */
/* Name         ATEMEGA_Key.c        Hardwaretreiber zum Tasteneinlesen  */
/* Version      1.0  :                                                   */
/*                                              // !!! update please !!! */
/* Author     : Volker Pritsching                                        */
/*                                                                       */
/* Language   : C                                                        */
/*                                                                       */
/* Description: Einlesen von Tasten am Paralellport: VX00A vpr           */
/*              Bitte hier eine Beschreibung eintragen                   */
/*                                                                       */
/**/
/*************************************************************************/
/*                                                                       */
/* 04.04.07 V001 Volker Pritsching  first code     !!! update please !!! */
/*                                                                       */
/*************************************************************************/
/*************************************************************************/
/*
1.1. Imports                                                               
*/
/*************************************************************************/
#include <stdio.h>
#include <string.h>

#include <avr/io.h>

#include "SystemGlobals.h"
#include "SystemCore.h"
#include "SystemSerialInterface.h"

#include "ATMEGA_key.h"

#undef DEBUG                     // local setting 

/*************************************************************************/
/*
1.2 Globals                                                               
*/
/*************************************************************************/
void sScanKey (void);


tKey sKey;

/************************************************************************/
unsigned int uiCurrent;
unsigned int uiPressed;
unsigned int uiChanged;
unsigned int uiReleased;
static unsigned int uiOld;

/*-----------------------------------------------------------------------*/
/*  Functions (aktualisieren, weitere Funktionen hinzufuegen)    */
/*-----------------------------------------------------------------------*/


/*************************************************************************/
/*
2.0 Locals                                                                
*/
/*************************************************************************/

/*************************************************************************/
/*
3. Modul Routinen KeyboardKeyboard    
*/
/*************************************************************************/
void fKeyInit(void){
#ifdef DEBUG 
fSerialSendStr("fKeyInit(mode=0x10)"); 
#endif
  sKey.cStatus = -1;
  sKey.ucAddr = 0x10;

uiPressed=0;
uiReleased =0;
sScanKey ();
}
/*************************************************************************/
void sPollKey(){
static unsigned char ucLast;
static unsigned char ucToggle =0;
static unsigned int uiWaitCounter;
unsigned char ucCurrent =0;

if (uiWaitCounter++ ==500){
  uiWaitCounter = 0;

#ifdef DEBUG 
fSerialSendStr("sPollKey()"); 
#endif
  
  if (sKey.ucAddr == 0x10){                         // Scan Parallel Key defined by ports
    if (!(PINC & 0x80)) ucCurrent = 0x34;
    if (!(PINC & 0x40)) ucCurrent = 0x20;
    if (!(PINC & 0x20)) ucCurrent = 0x11;
    if (!(PINC & 0x10)) ucCurrent = 0x10;
    if (!(PINC & 0x08)) ucCurrent = 0x21;
    if (!(PIND & 0x40)) ucCurrent = 0x38;
    if (!(PIND & 0x80)) ucCurrent = 0x0a;
    if (!(PINB & 0x10)) ucCurrent = 0x24;
    if (!(PINB & 0x08)) ucCurrent = 0x32;

    if ((sKey.cStatus == -1) && (ucCurrent)){
    if (ucCurrent != ucLast ) ucToggle ^= 0x01;
      sKey.cStatus = ucToggle;
      sKey.ucCode = ucCurrent;
      }
    ucLast = ucCurrent;
    }
  else if (sKey.ucAddr == 0x11){                  // scan one row without select
    if (!(PINC & 0x80)) ucCurrent = 0x34;
    if (!(PINC & 0x40)) ucCurrent = 0x20;
    if (!(PINC & 0x20)) ucCurrent = 0x11;
    if (!(PINC & 0x10)) ucCurrent = 0x10;
    }
  else if (sKey.ucAddr == 0x12){                  // scan 4 row without select row
    if (!(PINC & 0x80)) ucCurrent = 0x34;
    if (!(PINC & 0x40)) ucCurrent = 0x20;
    if (!(PINC & 0x20)) ucCurrent = 0x11;
    if (!(PINC & 0x10)) ucCurrent = 0x10;
    }
  }
}

/************************************************************************/
unsigned int getKeyCurrent (void) {
return uiCurrent;
}
/************************************************************************/
unsigned int getKeyPressed (void) {
unsigned int ret;
ret = uiPressed;
uiPressed =0;
return ret;
}
/************************************************************************/
unsigned int getKeyReleased (void) {
unsigned int ret;
ret = uiReleased;
uiReleased =0;
return ret;
}
/************************************************************************/
unsigned int getKeyChanged (void) {
unsigned int ret;
ret = uiChanged;
uiChanged =0;
return ret;
}
/************************************************************************/
void sScanKey (void){
  uiCurrent = 0xFFFF;
  if (!(PINC & 0x80)) uiCurrent &= ~0x0010;              // DE -
  if (!(PINC & 0x40)) uiCurrent &= ~0x0008;              // DE +
  if (!(PINC & 0x20)) uiCurrent &= ~0x0004;              // RA -
  if (!(PINC & 0x10)) uiCurrent &= ~0x0002;              // RA +
  if (!(PIND & 0x80)) uiCurrent &= ~0x0040;              // FOC -
  if (!(PIND & 0x40)) uiCurrent &= ~0x0020;              // FOC +
  if (!(PINC & 0x08)) uiCurrent &= ~0x0080;              // Shift
  if (!(PINB & 0x10)) uiCurrent &= ~0x0100;              // KU -
  if (!(PINB & 0x08)) uiCurrent &= ~0x0200;              // KU +
uiChanged |= uiCurrent ^ uiOld;
uiPressed  |= uiChanged & uiCurrent;
uiReleased |= uiChanged & uiOld;
uiOld = uiCurrent;
#ifdef DEBUG 
sprintf (tMSG_Buffer,"Current 0x%X: ",uiCurrent); fSerialSendStr(tMSG_Buffer); 
#endif
}
