/*************************************************************************/
/*
Inhalt
         1.0  : Handbox_tsfw.c
         1.1. Imports                                                               
         1.2 Globals  
         1.2.1 Prototypes of Functions
         2.0 Locals    
         3.  Modul Routinen ControlControl    
         3.1 Function    : Control_Init       
         3.2 Function    : fSetMode                
         3.3 Functions   : fTeleskopMove 
         3.4 Functions   : Timer             
         3.5 Function    : fSetGet_System                 
         4.1 ISR Routine : fNachfuehrung()            
         4.2 ISR Routine : sCONTROL_ISR_Task()     
         5.0 Task        : sControl_Task                                                  
*/
/*************************************************************************/
/*                                                                       */
/* Name     
         1.0  : Handbox.c                    Version in project: 001     */
/*                                              // !!! update please !!! */
/* Author     : Volker Pritsching                                        */
/*                                                                       */
/* Language   : C                                                        */
/*                                                                       */
/* Description: n Tasteneingabe, LCD 16x2 Ausagabe : VX00A vpr           */
/*              Bitte hier eine Beschreibung eintragen                   */
/*                                                                       */
/**/
/*************************************************************************/
/*                                                                       */
/* 04.05.07 V001 Volker Pritsching  first code     !!! update please !!! */
/*                                                                       */
/*************************************************************************/

/*************************************************************************/
/*
         1.1. Imports                                                               
*/
/*************************************************************************/
#include <stdio.h>                // Import C Standard IO sprintf
#include <string.h>               // Import C Stringfunktionen
#include <avr/io.h>               // Import ATMENGA IO

#include <avr/eeprom.h>           // Import zum lesen vom ATMEGA EEPROM
#include <avr/sleep.h>            // Import umschalten in ATMEGA Sleepmode

#include "ATMEGA_RC5.h"           // Interface RC5 Infrarot eingabe 
#include "ATMEGA_KEY.h"           // Interface Keyboard eingabe
#include "ATMEGA_LCD.h"           // Interface LCD Ausgabe
#include "ATMEGA_CLK.h"           // Interface Clock

#include "System_RS232.h"         // Interface RS232 Ein/Ausgabe
#include "SystemGlobals.h"         
#include "SystemCore.h"           // Interface Systemcore
#include "Dog_tsfw.h"         // Interface Handboxprogramme

#undef DEBUG

/*************************************************************************/
/*
        1.2 Globals                                                               
*/
/*************************************************************************/
#define MASTERCLOCK 50 //Taktfrequenz in Hz des Hautptacktes

//Macros zum set und reset der IO's  der EOS 300D
#define Set_SLR1 PORTB|=0x02      
#define Reset_SLR1 PORTB&=~0x02
#define Set_SLR2 PORTB|=0x04
#define Reset_SLR2 PORTB&=~0x04

// zuordnung der Steuertasten up, down left und right zur Hardware
#define keyB 0x38 //Key brightness 
#define keyC 0x11 //Key constast
#define keyM 0x21 //Key Mode 
#define keyU 0x0a //Key Up 

/*************************************************************************/
/*
         1.2.1 Prototypes of Functions
*/
/*-----------------------------------------------------------------------*/
/* Prototypes of Functions for Command Interpreter: Commands and Queries */
/*-----------------------------------------------------------------------*/
extern unsigned char ucClockUpdate;

unsigned int uiCounterMOFA;
unsigned char ucPreHandbox =0;
//unsigned char ucUpdateTimer =0;

void fSerialSendChar(unsigned char);
unsigned short fSerialSendStr(char *pc);
unsigned char fDisplay(unsigned char,char *pc);
unsigned char const Cchar[8][9] = 
{{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0},
 {0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0},
 {0x0,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0},
 {0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xff,0},
 {0x0,0x0,0x0,0xff,0xff,0xff,0xff,0xff,0},
 {0x0,0x0,0xff,0xff,0xff,0xff,0xff,0xff,0},
 {0x0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0},
 {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0}
};
/*-----------------------------------------------------------------------*/
/*  Functions (aktualisieren, weitere Funktionen hinzufuegen)    */
/*-----------------------------------------------------------------------*/
static unsigned short fWLine(char *tParm);
static unsigned short fRLine(char *tParm);
static unsigned short fINIT(char *tParm);
COM_DEF asHandbox_ComDef [] =

{
   {":WL",                 fWLine},
   {":RL?",                fRLine},
   {":INIT",               fINIT},
   
    {NULL,                   NULL}              // array must end with NULL
};
/*************************************************************************/
void fHandbox_Init(void){
int i;
//  rc5_init (0);


//for (i=0;i<8 ; i++) fCharRAM (i, Cchar[i]);
  strcpy(tMSG_Buffer,"Nuernberg      ");
for (i=9;i<16;i++) tMSG_Buffer[i] = i-8;
tMSG_Buffer[i] = 0;
tMSG_Buffer[0] = 0x00;    //A
tMSG_Buffer[1] = 0x00;
tMSG_Buffer[2] = 0x00;
tMSG_Buffer[3] = 0x00;
tMSG_Buffer[4] = 0x00;
tMSG_Buffer[5] = 0x00;
tMSG_Buffer[6] = 0x00;
tMSG_Buffer[7] = 0x00;
fFillRAM(0,tMSG_Buffer);    //b
fFillRAM(1,tMSG_Buffer);    //C
fFillRAM(2,tMSG_Buffer);    //D
fFillRAM(3,tMSG_Buffer);   //  E
fFillRAM(4,tMSG_Buffer);    //F
fFillRAM(5,tMSG_Buffer);    //  G
fFillRAM(6,tMSG_Buffer);   // H
tMSG_Buffer[0] = 0x00;
tMSG_Buffer[1] = 0x7f;
tMSG_Buffer[2] = 0x08;
tMSG_Buffer[3] = 0x08;
tMSG_Buffer[4] = 0x08;
tMSG_Buffer[5] = 0x7f;
tMSG_Buffer[6] = 0x00;
tMSG_Buffer[7] = 0x00;
fFillRAM(7,tMSG_Buffer);
  fDisplay(1,"Display DOGM 162");              // Init Text nach Power on
//  fDisplay(2,tMSG_Buffer);
 // fDisplay(3,"                ");
 // OCR1A = 200;;                                // Timer A
//  OCR1B = 200;                                 // Timer B
}

/*************************************************************************/
/*                                                                       */
/* 
         3.6 Function   : fTestfunction            > Query <        
*/
/*                                                                       */
/* Description:                            */
/*                                                                       */
/* Return     :                                */
/*                                                                       */
/*                                                                       */
/*************************************************************************/
static unsigned short fRLine (char *pcParm ){
//pcParm=NULL; // missbrauch als varialblentestausgabe 
int iValue;
char tLine[17];
  sscanf (pcParm, "%i %s",&iValue, &tLine[0]);
//  if ( fLCD_Init() == ok)          fSerialSendStr((char *)IDN_STRING);
//  else                             fSerialSendStr("LCD absent  ");  
RETURN( NO_ERR, tMSG_Buffer );
}
/*************************************************************************/
/*                                                                       */
/* 
         3.6 Function   : fTestfunction            > Query <        
*/
/*                                                                       */
/* Description:                            */
/*                                                                       */
/* Return     :                                */
/*                                                                       */
/*                                                                       */
/*************************************************************************/
static unsigned short fINIT(char *pcParm ){

pcParm = NULL;

  fHandbox_Init();

RETURN( NO_ERR, tMSG_Buffer );
}
/*************************************************************************/
/*                                                                       */
/* 
         3.6 Function   : fTestfunction            > Query <        
*/
/*                                                                       */
/* Description:                            */
/*                                                                       */
/* Return     :                                */
/*                                                                       */
/*                                                                       */
/*************************************************************************/
static unsigned short fWLine(char *pcParm ){

int iZ,iP,i;
char cS[18];
  sscanf (pcParm, "%i %i %s",&iZ,&iP,cS);

  for (i=0;i<16;i++) {
    if ((cS[i] == '_') || (cS[i] < 0x10))  cS[i] =0x20;
	}

  cS[16] =0;
  switch (iZ){
    case 0:
        fDisplay (1, cS);
	   break;
    case 1: 
        fDisplay (2, cS);
	   break;
	default:
       fDisplay (4, "  Undefined  ");
	   break;
	   }

RETURN( NO_ERR, NULL );
}

/*************************************************************************/
/*                                                                       */
/* statemaschine fr die Kuppelsteuerung                                 */
/*                                                                       */
/*                                                                       */
/*                                                                       */
/*************************************************************************/
#define left  0x0100
#define right 0x0200

enum {Idle,Start,Run,Wait};               // Zustaende Statemaschine
unsigned char ucStateKuppel = Idle;       // nach reset idle
unsigned int  uiAchse =0;                 // merker letzte Fahrtrichtung 
unsigned char ucTimerKuppel=0;            // Zeit 

void sStateMashineKuppel(unsigned int uiCurrent){
//	      sprintf(tMSG_Buffer,"Keys: 0x%x",uiCurrent); fSerialSendStr(tMSG_Buffer);
switch (ucStateKuppel){
  case Idle:
    if (uiCurrent == ~left){              // wenn Taste left gedrckt
      #ifdef DEBUG
      sprintf(tMSG_Buffer,"Kuppel left"); fSerialSendStr(tMSG_Buffer);
      #endif
	  uiAchse = left;                     // Merker der letzten richtung
	  PORTB &= ~0x06;                     // Portbits reset
	  PORTB |=  0x04;                     // Portbit left setzen 
	  ucTimerKuppel = 0;                  // Timer Neu starten
	  ucStateKuppel = Start;              // status statemashine weiterschalten
      #ifdef DEBUG
       sprintf(tMSG_Buffer,"Kuppel Start"); fSerialSendStr(tMSG_Buffer);
      #endif
	  }
    if (uiCurrent == ~right){             // wenn Taste right gedrueckt
      #ifdef DEBUG
	  sprintf(tMSG_Buffer,"Kuppel right"); fSerialSendStr(tMSG_Buffer);
      #endif
	  uiAchse = right;                     // Merker letzte Richtung
	  PORTB &= ~0x06;                      // Portbits reset
	  PORTB |=  0x02;                      // Portbit right setzen
	  ucTimerKuppel = 0;                   // Timer neu starten
	  ucStateKuppel = Start;               // Status Statemaschine weiterschalten
      #ifdef DEBUG
      sprintf(tMSG_Buffer,"Kuppel Start"); fSerialSendStr(tMSG_Buffer);
      #endif
	  }
    break;
  case Start:                              // Kuppel gestartet 
      if (ucTimerKuppel > 5) ucTimerKuppel =6; // laenger als 5 sec gedrckt, dann dauerlauf
	  if (uiCurrent == 0xffff) {           // alle Tasten losgelassen
        if (ucTimerKuppel > 5) {           // und Bewegungstaste lnger als 5 sec gedrueckt
	      ucStateKuppel = Run;             // status Statemaschine: dauerlauf Kuppel 
          #ifdef DEBUG
          sprintf(tMSG_Buffer,"Kuppel run"); fSerialSendStr(tMSG_Buffer);
          #endif
		  }
        else {
	      PORTB &= ~0x06;                  // taste kuerzer als 5 sec dedrckt:stop
	      ucStateKuppel = Wait;            // Satus Statemachine Kuppel: wartezeit bis Kuppel steht
	      ucTimerKuppel = 21;              // wartezeit fr richtungsumkehr setzen
          #ifdef DEBUG
          sprintf(tMSG_Buffer,"Kuppel wait"); fSerialSendStr(tMSG_Buffer);
          #endif
		  }
		}
      break;
  case Run:
	  if(uiCurrent != 0xffff)  {            // Bewegungsabbruch durch Tastendruck
        #ifdef DEBUG
        sprintf(tMSG_Buffer,"Kuppel wait"); fSerialSendStr(tMSG_Buffer);
        #endif
	    PORTB &= ~0x06;                     // stop Kuppelmotor
	    ucStateKuppel = Wait;               // Status Statemaschine Kuppel: wartezeit bis kuppel steht
	    ucTimerKuppel = 21;                 // wartezeit fr richtungsumkehr setzen
	    } 
      if (ucTimerKuppel > 40){              // Stop Kuppel nach 40 sec
        #ifdef DEBUG
        sprintf(tMSG_Buffer,"Kuppel wait"); fSerialSendStr(tMSG_Buffer);
        #endif
	    PORTB &= ~0x06;                     // stop kuppelmotor
	    ucStateKuppel = Wait;               // Status Statemaschine Kuppel: wartezeit bis kuppel steht
	    ucTimerKuppel = 21;                 // wartezeit fr richtungsumkehr setzen
        }
    break;
  case Wait:
      if((uiCurrent == ~left)  && (uiAchse == left)) { // taste left innerhalb der Wartezeit gedrckt
	    PORTB &= ~0x06;                      // stop Motor   
	    PORTB |=  0x04;                      // restart Motor in der selben richtung  
        #ifdef DEBUG
        sprintf(tMSG_Buffer,"Kuppel run left"); fSerialSendStr(tMSG_Buffer);
        #endif
 	    ucStateKuppel = Start;                // zurck in den Start state
		}
      if((uiCurrent == ~right) && (uiAchse == right)) { // taste left innerhalb der Wartezeit gedrckt
	    PORTB &= ~0x06;                       // stop Motor
	    PORTB |=  0x02;                       // restart Motor in der selben richtung
        #ifdef DEBUG
        sprintf(tMSG_Buffer,"Kuppel run right"); fSerialSendStr(tMSG_Buffer);
        #endif
 	    ucStateKuppel = Start;                // zuruek in den Startstate
		}
       if (ucTimerKuppel > 22){               // warteZeit Abgelaufen beide richtung sind wieder mglich
	     ucStateKuppel = Idle;
#ifdef DEBUG
       sprintf(tMSG_Buffer,"Kuppel idle"); fSerialSendStr(tMSG_Buffer);
#endif
	   }
   break;
  default:
    break;
  }
}
/*************************************************************************/
void fSerialSendChar(unsigned char CHAR){
#ifdef DEBUG
   sprintf(tMSG_Buffer,"KeyCode 0x%X ",CHAR); fSerialSendStr(tMSG_Buffer);
#else
   sprintf(tMSG_Buffer,"KeyCode 0x%X ",CHAR); fSerialSendStr(tMSG_Buffer);
//   fSerial_putKey(CHAR);
#endif
}
/*************************************************************************/
void sCycleHandbox(void) {    // wird in der Rubberbendig Loop aufgerufen 
// unsigned char ucH,ucM,ucS;     // Zeitangaben gespittet
// extern unsigned long int  ulTime;  // Realtimeclock in sekunden
unsigned  int uiT,uiK;
unsigned char ucT;                 // Tastencode als byte
static unsigned char ucIndex;      // laufbalken index
unsigned char i;


strcpy(tMSG_Buffer,"    HHHHH       ");
if (!(PINC & 0x80)) tMSG_Buffer[4] = 1; else tMSG_Buffer[4] = 3;
if (!(PINC & 0x40)) tMSG_Buffer[5] = 1; else tMSG_Buffer[5] = 4;
if (!(PINC & 0x20)) tMSG_Buffer[6] = 1; else tMSG_Buffer[6] = 5;
if (!(PINC & 0x10)) tMSG_Buffer[7] = 1; else tMSG_Buffer[7] = 6;
if (!(PINC & 0x08)) tMSG_Buffer[8] = 1; else tMSG_Buffer[8] = 7;
//if (!(PINC & 0x04)) tMSG_Buffer[9] = 1; else tMSG_Buffer[9] = 6;
//if (!(PINC & 0x02)) tMSG_Buffer[10] = 1; else tMSG_Buffer[10] = 6;
//if (!(PINC & 0x01)) tMSG_Buffer[11] = 1; else tMSG_Buffer[11] = 6;
//fSerialSendStr(tMSG_Buffer);
//fDisplay(2,tMSG_Buffer);
//tMSG_Buffer[0] = 0x00;
//tMSG_Buffer[1] = 0x7f;
//tMSG_Buffer[2] = 0x49;
//tMSG_Buffer[3] = 0x49;
//tMSG_Buffer[4] = 0x49;
//tMSG_Buffer[5] = 0x41;
//tMSG_Buffer[6] = 0x00;
//tMSG_Buffer[7] = 0x00;
//fFillRAM(6,tMSG_Buffer);



if (ucClockUpdate) {        // rubberbendeing Aufruf alle Sekunde
   ucTimerKuppel++;
   ucClockUpdate =0;
/*
   ucH = (unsigned char) (ulTime / 3600);      // update Stunde
   uiT = (unsigned int)  (ulTime % 3600);      // berechne Minute Sekunde
   ucM = (unsigned char) (uiT / 60);           // update Minute
   ucS = (unsigned char) (uiT % 60);           // update Secunde
   sprintf(tMSG_Buffer,"Time: %02i:%02i:%02i",ucH,ucM,ucS);
   fDisplay(3,tMSG_Buffer);
*/


/* Laufbalken auf den Display */

   if(ucIndex++ >15) ucIndex = 1;

   if(ucIndex==1) { 
      strcpy(tMSG_Buffer, "                ");
      tMSG_Buffer[0] = 6;
//	  fDisplay(1,tMSG_Buffer);
	  }
   else {
     tMSG_Buffer[0] = 6; tMSG_Buffer[1]=0; 
//	 fDisplay ((ucIndex-1) | 0x10,tMSG_Buffer);
	 }
   }

uiT = getKeyChanged();            // einlesen der Tasten mit Statuswechsel
uiK = getKeyCurrent();            // einlesen des aktuellen Tastenstatus
sStateMashineKuppel(uiK);         // statemaschine Kuppelsteuerung

if (uiT & 0x00FF){                 // senden eines gueltigen Tastencode            
   ucT = (unsigned char) uiK;
   switch (ucT){
     case 0xED:                    // DE- ; RA+
     case 0xEB:                    // DE- ; RA-
     case 0xF5:                    // DE+ ; RA+
     case 0xF3:                    // DE+ ; RA-
     case 0x3F:                    // v Foc -
     case 0x5F:                    // v FOC +
     case 0x6F:                    // v DE  -
     case 0x77:                    // v DE  +
     case 0x7F:                    // v select
     case 0xBF:                    // FOC -
     case 0xDF:                    // FOC +
     case 0xEF:                    // DE - 
     case 0xF7:                    // DE +
     case 0xFB:                    // RA -
     case 0xFD:                    // RA +
     case 0xFF:                    // alle released
       fSerialSendChar(ucT);
	   break;
     default:
       break;
	 }
   }
}

