/*************************************************************************/
/*
Inhalt
         1.0  : Flux_tsfw.c
         1.1. Imports                                                               
         1.2 Globals  
         1.2.1 Prototypes of Functions
         2.0 Locals    
         3.  Modul Routinen ControlControl    
         3.1 Function    : Init       
         3.2 Function    : f              
         3.4 Functions   : Timer             
         3.5 Function    : fSetGet_System                 
         4.1 ISR Routine : ISR_FotoTimerTask()     
         5.0 Task        : sCycleFotoTimer()                                                  
*/
/*************************************************************************/
/*                                                                       */
/* Name     
         1.0  : TeleskopControl.c             Version in project: 001     */
/*                                              // !!! update please !!! */
/* Author     : Volker Pritsching                                        */
/*                                                                       */
/* Language   : C                                                        */
/*                                                                       */
/* Description: Kleinsteuerung f r Telekope version: VX00A vpr           */
/*              Bitte hier eine Beschreibung eintragen                   */
/*                                                                       */
/**/
/*************************************************************************/
/*                                                                       */
/* 04.04.04 V001 Volker Pritsching  first code     !!! update please !!! */
/*                                                                       */
/*************************************************************************/

/*************************************************************************/
/*
         1.1. Imports                                                               
*/
/*************************************************************************/
#include <stdio.h>
#include <string.h>
#include <avr/io.h>
#include <avr/eeprom.h>
#include <avr/sleep.h>
#include "ATMEGA_LCD.h"
#include "ATMEGA_CLK.h"
#include "SYSTEMGLOBALS.h"
#include "SYSTEMCORE.h"
#include "Flux_TSFW.h"

#undef DEBUG
#define DEBUG
/*************************************************************************/
/*
        1.2 Globals                                                               
*/
//enum {Idle,Run,Setup,SetEx,SetPause,SetReload,Exposure,Pause,Wait,SetContrast,SetBrightness};
/*************************************************************************/
#define MASTERCLOCK 50 //Taktfrequenz in Hz des Hautptacktes


unsigned char ucStatusISR;       // StatusFlag , x, x, x, TS, MS2, MS1, MS0

extern unsigned long int ulTime;
/*************************************************************************/
/*
        1.2 Modul Global                                                               
*/

tTimeDate tNow;

char cChannelIndex;
double fTemperature;
static unsigned int uiMagSensor[6];
static char ucDeviceID[8];
static char cScratch[9];

unsigned char OW_Reset ();
unsigned char OW_ReadBit (unsigned char ucChannel);
unsigned char OW_ReadByte(unsigned char ucChannel);
unsigned char OW_ReadDeviceAdress(unsigned char ch, char *DeviceAddress);
void OW_WriteBit (unsigned char ch, unsigned char ucValue);
void OW_WriteByte (unsigned char ucChannel,char ucValue); 

void fSerialSendStr( char *Buffer);
/*************************************************************************/
/*
         1.2.1 Prototypes of Functions
*/
/*-----------------------------------------------------------------------*/
/* Prototypes of Functions for Command Interpreter: Commands and Queries */
/*-----------------------------------------------------------------------*/

static unsigned short fTemperatureRead (char *tParm);
static unsigned short fMagnetSensorRead(char *tParm);
static unsigned short fIDRead (char *tParm);
/*-----------------------------------------------------------------------*/
/*  Functions (aktualisieren, weitere Funktionen hinzufuegen)    */
/*-----------------------------------------------------------------------*/
COM_DEF asFlux_ComDef [] =
{
   {":TEMP:READ?",                 fTemperatureRead},
   {":MAGS:READ?",                 fMagnetSensorRead},
   {":READ?",                      fIDRead},
   
   { NULL,                  NULL}                // array must end with NULL
};

/*************************************************************************/
/*
         TSFW Interface Calls
*/
/*************************************************************************/
void fFlux_Init(void){
	DDRB  = 0xFD;  // pB1 is Input
TCCR1A = 0; 
TCCR1B = 0;    //Disable Source clock
TCNT1  = 0;    //clear Counterregister
	cChannelIndex = 0;
	fTemperature =0.0;
	uiMagSensor[0] =4000;
	uiMagSensor[1] =8000;
	uiMagSensor[2] =12000;
	uiMagSensor[3] =16000;
	uiMagSensor[4] =20000;
	uiMagSensor[5] =24000;
	PORTB &= ~0x1D;                    // set Channelselect =0 
	
	fSerialSendStr("Flux is on the air");
	fDisplay(2,"Init Flux       ");


}
/*************************************************************************/
/*
         2.0 Modul Locals Variable    
*/
/*************************************************************************/
unsigned char OW_Reset();
void OW_Delay(unsigned int);
unsigned char OW_ReadDeviceAddress(unsigned char, char *Buffer);
int OW_GetTemperature(unsigned char ch);
/*************************************************************************/
/*                                                                       */
/* 
         3.4 Functions   : MOFA            
*/
/*                                                                       */
/* Description:                            */
/*                                                                       */
/* Return     :                                */
/*                                                                       */
/*                                                                       */
/*************************************************************************/
static unsigned short fTemperatureRead (char *pcParm){
	int i=0;
	 i= OW_GetTemperature(0);
	 if (i % 2) {
	 sprintf (tMSG_Buffer,"0x%02X 0x%02x Temp: %i.5 C",
                       cScratch[1],cScratch[0],i/2);
	 }
	 else {
	 sprintf (tMSG_Buffer,"0x%02X 0x%02x Temp: %i C",
                       cScratch[1],cScratch[0],i/2);
	 }
  RETURN( NO_ERR, tMSG_Buffer);
}
/*************************************************************************/
static unsigned short fMagnetSensorRead (char *pcParm){
	int iValue;
  	if((sscanf (pcParm, "%i", &iValue)) == 0) {
     	sprintf (tMSG_Buffer,"M2=%u M1=%u M0=%u",uiMagSensor[2],uiMagSensor[1],uiMagSensor[0]);
     	RETURN( NO_ERR, tMSG_Buffer);
     	}
  	else
     	sprintf (tMSG_Buffer,"Magnetsensor %i: %i",iValue,uiMagSensor[iValue]);
  	RETURN( NO_ERR, tMSG_Buffer);
	}

/*************************************************************************/

/*************************************************************************/
static unsigned short fIDRead (char *pcParm){
 // OW_ReadDeviceAddress(1, ucDeviceID);
  	sprintf (tMSG_Buffer,"0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x",
                       ucDeviceID[7],ucDeviceID[6],ucDeviceID[5],ucDeviceID[4],
					   ucDeviceID[3],ucDeviceID[2],ucDeviceID[1],ucDeviceID[0]); 
  	RETURN( NO_ERR, tMSG_Buffer);
	}
/*************************************************************************/

void sCycleFlux(void) {   
	static int iTemperatur1,iTemperatur2,iTemperatur3;



	if (uiCounterFlux !=0){
//sprintf(tMSG_Buffer, "%i=%i",(PORTB & 0x1c), uiCounterFlux);fSerialSendStr(tMSG_Buffer);
		switch (PORTB & 0X1C){ // mask Bits xxx1 11xx
			case 0x04: // channel 1
      			uiMagSensor[0] = uiCounterFlux;
//      			sprintf(tMSG_Buffer,"T %i X1  %05u ",iTemperatur1,uiMagSensor[0]); fSerialSendStr(tMSG_Buffer);
				break;
			case 0x08: // channel 2
//				iTemperatur1 = OW_GetTemperature(0)/16;
      			uiMagSensor[1] = uiCounterFlux;
//      			sprintf(tMSG_Buffer,"T %i X2  %05u ",iTemperatur1,uiMagSensor[1]); fSerialSendStr(tMSG_Buffer);
				break;
			case 0x0c: // channel 3
      			uiMagSensor[2] = uiCounterFlux;
//      			sprintf(tMSG_Buffer,"T %i Y1  %05u ",iTemperatur2,uiMagSensor[2]); fSerialSendStr(tMSG_Buffer);
				break;
			case 0x10:  // channel 4
				iTemperatur2 =0;// OW_GetTemperature(1)/16;
      			uiMagSensor[3] = uiCounterFlux;
//     			sprintf(tMSG_Buffer,"T %i Y2  %05u ",iTemperatur2,uiMagSensor[3]); fSerialSendStr(tMSG_Buffer);
				break;
			case 0x14:  //channel 5
      			uiMagSensor[4] = uiCounterFlux;
//     			sprintf(tMSG_Buffer,"T %i Z1  %05u ",iTemperatur3,uiMagSensor[4]); fSerialSendStr(tMSG_Buffer);
				break;
			case 0x00:  // channel 0
				iTemperatur3 =  OW_GetTemperature(2)/2;
      			uiMagSensor[5] = uiCounterFlux;
//      			sprintf(tMSG_Buffer,"T %i Z2  %05u ",iTemperatur3,uiMagSensor[5]);  fSerialSendStr(tMSG_Buffer);
				sprintf (tMSG_Buffer,"%lu;%i;%u;%u;%i;%u;%u;%i;%u;%u\n", ulTime, iTemperatur1,uiMagSensor[5], uiMagSensor[4],
																			   iTemperatur2,uiMagSensor[3], uiMagSensor[2],
																			   iTemperatur3,uiMagSensor[1], uiMagSensor[0]);
   				ucStatusISR = 0;
   				fSerialSendStr(tMSG_Buffer);
			default:
			break;
			} 
		uiCounterFlux =0;
		}
	if ((ulTime %334) == 0) ulTime++;
	
DDRC |=	0x03;
PORTC ^= 0x02;
//OW_GetTemperature(0); 
//OW_GetTemperature(1);
//sprintf(tMSG_Buffer,"ch2 = 0x%x", OW_GetTemperature(2));fSerialSendStr(tMSG_Buffer);
	//OW_GetTemperature(1);
	}


