/********************************************************************/
/*                                                                  */
/* Name       : ATmega128_tsfw.c          Version: 001.vpr            */
/*                                                                  */
/* Author     : Volker Pritsching                                   */
/* template   : by Gerhard Ort                                      */
/*                                                                  */
/* Language   : C                                                   */
/*                                                                  */
/* Description: FW template                                         */
/*              Standard Fujitsu functions                          */
/*                                                                  */
/*                                                                  */
/********************************************************************/
/*                                                                  */
/* 14.4.07 V001
      http://www.roboternetz.de/wissen/index.php/RC5-Decoder_f%C3%BCr_ATMega  */
/*               from BIST_Software for mcb2, STATE004              */
/* 14.04.07 V001 Volker Pritsching angepasst an die testsoftware    */
/********************************************************************/


/********************************************************************/
/* Imports                                                          */
/********************************************************************/
#include <stdio.h>
#include <string.h>

#include <avr/io.h>
#include <avr/interrupt.h>
#include <util/delay.h>

#include <SystemSerialInterface.h>

unsigned char OW_ReadDeviceAdress( unsigned char ch,char *DeviceAddress);
void OW_ReadScratchMemory (unsigned char ch,unsigned char *buffer);
void fSerialSendStr ( unsigned char *disp_buffer);

/* ******************************************************************************** */ 

extern unsigned char tMSG_Buffer[];

/* ******************************************************************************** */ 

typedef union { 
   unsigned int w; 
   unsigned char ucB[2];
   } code_t; 
   

/* ******************************************************************************** */ 
/*                                                                                  */
/*  OneWire Delay                                                                   */

#define DataLine0Input   DDRC  &= ~0x80
#define DataLine0Output  DDRC  |=  0x80
#define DataLine0Low     PORTC &= ~0x80           // Data 0
#define DataLine0High    PORTC |=  0x80           // Data 1
#define DataIn0         (PINC & 0x80) >> 7

#define DataLine1Input   DDRC  &= ~0x40
#define DataLine1Output  DDRC  |=  0x40
#define DataLine1Low     PORTC &= ~0x40           // Data 0
#define DataLine1High    PORTC |=  0x40           // Data 1
#define DataIn1         (PINC & 0x40) >> 6

#define DataLine2Input   DDRC  &= ~0x20
#define DataLine2Output  DDRC  |=  0x20
#define DataLine2Low     PORTC &= ~0x20           // Data 0
#define DataLine2High    PORTC |=  0x20           // Data 1
#define DataIn2         (PINC & 0x20) >> 5




//void _delay_us( double __us);


/* ******************************************************************************** */ 
/*
	switch (channel{
		case 0:
		break;
		case 1:
		break;
		case 2:
		break;
		default:
		break;
	}

                                                                                  */
/*  OneWire Reset                                                                   */
/*                                                                                  */
/* ******************************************************************************** */ 
unsigned char OW_Reset (unsigned char channel) { 
	switch (channel) {
		case 0:
		  DataLine0Output;				// set data line to write mode
		  DataLine0Low;                 // set dateline 0 for 480s
		  _delay_us (480); 
		  DataLine0High;				// set internal pullup             
		  DataLine0Input;				// set data line to read mode
		  _delay_us (70);				// wait 70s before read 
		  if (DataIn0 ==1) return(1);	// device not present ==> return error
		  _delay_us (420);				// wait until bus is idle
		break;
		case 1:
		  DataLine1Output;				// set data line to write mode
		  DataLine1Low;                 // set dateline 0 for 480s
		  _delay_us (480);
		  DataLine1High;				// set internal pullup
		  DataLine1Input;				// set data line to read mode
		  _delay_us (70);				// wait 70s before read
		  if (DataIn1 ==1) return(1);	// device not present ==> return error
		  _delay_us (420);				// wait until bus is idle
		break;
		case 2:
		  DataLine2Output;				// set data line to write mode
		  DataLine2Low;                 // set dateline 0 for 480s
		  _delay_us (480);
		  DataLine2High;				// set internal pullup
		  DataLine2Input;				// set data line to read mode
		  _delay_us (70);				// wait 70s before read
		  if (DataIn2 ==1) return(1);	// device not present ==> return error
		  _delay_us (420);				// wait until bus is idle
		break;
		default:
		break;
	}
	return(0);	                        // device present ==> return no error
}
/* ******************************************************************************** */ 
/*                                                                                  */
/*  OneWire Read Bit                                                                */
/*                                                                                  */
/* ******************************************************************************** */ 
unsigned char OW_ReadBit (unsigned char channel){
unsigned char data=0;
	switch (channel){
		case 0:
			DataLine0Output;			// set data line to write mode 
			DataLine0Low;	            // Start read with 1 s low puls
			DataLine0High;				// set internal pullup
			DataLine0Input;				// set data line to read mode
			_delay_us (15);				// wait 15us until data valid
			data = DataIn0;				// read data
	        _delay_us (104);			// wait read slot finised OW_Delay(19);
			break;
		case 1:
			DataLine1Output;			// set data line to write mode
			DataLine1Low;	            // Start read with 1 s low puls
			DataLine1High;				// set internal pullup
			DataLine1Input;				// set data line to read mode
			_delay_us (15);				// wait 15us until data valid
			data = DataIn1;				// read data
			_delay_us (104);			// wait read slot finised OW_Delay(19);
		break;
		case 2:
			DataLine2Output;			// set data line to write mode
			DataLine2Low;	            // Start read with 1 s low puls
			DataLine2High;				// set internal pullup
			DataLine2Input;				// set data line to read mode
			_delay_us (15);				// wait 15us until data valid
			data = DataIn2;				// read data
			_delay_us (104);			// wait read slot finised OW_Delay(19);
		break;
		default:
		break;
	}
	return (data);
}
/* ******************************************************************************** */ 
/*                                                                                  */
/*  OneWire Write Bit                                                               */
/*                                                                                  */
/* ******************************************************************************** */ 
void OW_WriteBit (unsigned char channel,unsigned char ucValue){
	switch (channel){
		case 0:
			DataLine0Output;;			// set data line to write mode
			DataLine0Low;	            // Start read with 1 s low pulse
			if (ucValue >0) DataLine0High;	// change level if Bit is set
			_delay_us (104);			// wait write slot finished
			DataLine0High;				// set internal pullup
			DataLine0Input;				// set data line to read mode
		break;
		case 1:
			DataLine1Output;;			// set data line to write mode
			DataLine1Low;	            // Start read with 1 s low pulse
			if (ucValue >0) DataLine1High;	// change level if Bit is set
			_delay_us (104);			// wait write slot finished
			DataLine1High;				// set internal pullup
			DataLine1Input;				// set data line to read mode
		break;
		case 2:
			DataLine2Output;;			// set data line to write mode
			DataLine2Low;	            // Start read with 1 s low pulse
			if (ucValue >0) DataLine2High;	// change level if Bit is set
			_delay_us (104);			// wait write slot finished
			DataLine2High;				// set internal pullup
			DataLine2Input;				// set data line to read mode
		break;
		default:
		break;
	}
}
/* ******************************************************************************** */ 
/*                                                                                  */
/*  OneWire Read Byte                                                               */
/*                                                                                  */
/* ******************************************************************************** */ 
unsigned char OW_ReadByte(unsigned char channel) {
unsigned char i;
unsigned char ucValue =0;
for (i=0;i<8;i++){
  if (OW_ReadBit(channel)) ucValue|= 0x01 <<i; 
  }
//  sprintf(tMSG_Buffer,"0x%02x",ucValue); fSerialSendStr(tMSG_Buffer);

return (ucValue);
}
/* ******************************************************************************** */ 
/*                                                                                  */
/*  OneWire Write Byte                                                              */
/*                                                                                  */
/* ******************************************************************************** */ 
void OW_WriteByte (unsigned char channel,char ucValue) {
unsigned char i;
unsigned char ucTemp;
for (i=0;i<8;i++){
  ucTemp = ucValue >>i;
  ucTemp &=0x01;
  OW_WriteBit(channel,ucTemp);
  }
	_delay_us (104);//OW_Delay(16);
}
/* ******************************************************************************** */ 
/*                                                                                  */
/*  Hight Level Routines.                                                           */
/*                                                                                  */
/* ******************************************************************************** */ 

unsigned char OW_ReadDeviceAddress(unsigned char channel, char *DeviceAddress){
int i;

if (OW_Reset(channel) ==0) {
  OW_WriteByte(channel,0x33);
  for (i=0;i<8;i++){
    DeviceAddress[i] = OW_ReadByte(channel);
	}
  return (0);
  }
return (1);                                      // device error
}

unsigned char OW_StartConversion(unsigned char channel,char *cDeviceAddress){
int i;

if (OW_Reset(channel) ==0) {
  OW_WriteByte(channel,0x55);
  for (i=0;i<8;i++){
     OW_WriteByte(channel,cDeviceAddress[i]);
	}
  OW_WriteByte(channel,0x44);
  return (0);
  }
return (1);                                      // device error
}
unsigned char OW_ReadDeviceMemory(unsigned char channel, char *cDeviceAddress, char *cSrcatchMemory){
int i;
if (OW_Reset(channel) ==0) {
  OW_WriteByte(channel,0x55);
  for (i=0;i<8;i++){
     OW_WriteByte(channel,cDeviceAddress[i]);
	}
  OW_WriteByte(channel,0xBE);
  for (i=0;i<9;i++){
    cSrcatchMemory[i] = OW_ReadByte(channel);
//  sprintf(tMSG_Buffer,"Data %i: 0x%02X",i,i);// cSrcatchMemory[i]);	fSerialSendStr(tMSG_Buffer);
	}
  return (0);
  }
return (1);                                      // device error
}
/* ******************************************************************************** */
/*                                                                                  */
/*    read Temperature from 18DS20 only for one device at bus                       */
/*    Hardware ATMEGA32 mit max 3 1Wire bussen                                      */
/* ******************************************************************************** */
int OW_GetTemperature(unsigned char channel){
int iT=999,i;
PORTC |= 0x01;
  if (OW_Reset(channel) ==1) {PORTC &= 0xFE; return (440);	}	// initialize if not available return 
PORTC &= 0xFE;
  OW_WriteByte(channel,0xCC);					// 1Wire Command: Skip Rom
  OW_WriteByte(channel,0x44);					// 1Wire Command: Start Conversion
  while ( OW_ReadBit(channel) == 0);			// Wait until conversion done
  
  if (OW_Reset(channel) ==1) return(444);       // Initialize read sequence
  
  OW_WriteByte(channel,0xCC);					// 1Wire Command: Skip Rom
  OW_WriteByte(channel,0xBE);					// 1Wire Command: Read 
  i   = (unsigned int) OW_ReadByte(channel);	// Low byte
  iT  = ((unsigned int) OW_ReadByte(channel) << 8) + i;
  
 // OW_Reset(channel); 
  return((int) iT);
}







