/****************************************************************************************/
/*                                                                                      */
/* Name       : TCI_CORE.h          Version: 001.020215go                               */
/*                                                                                      */
/* Author     : Gerhard Ort                                                             */
/*                                                                                      */
/* Language   : C                                                                       */
/*                                                                                      */
/* Description: Include File of TCI_CORE (communication core) module                    */
/*                                                                                      */
/****************************************************************************************/
/*                                                                                      */
/* 14.05.99 V001 Gerhard Ort File created                                               */
/*                                                                                      */
/****************************************************************************************/

/*--------------------------------------------------------------------------------------*/
/* include control                                                                      */
/*--------------------------------------------------------------------------------------*/
#ifndef __INC_SystemCommandInterpreter
#define __INC_SystemCommandInterpreter


/****************************************************************************************/
/* Imports                                                                              */
/****************************************************************************************/
#include "SystemGlobals.h"
#include "SystemSerialInterface.h"
#include "SystemCore.h"


/****************************************************************************************/
/* Exports                                                                              */
/****************************************************************************************/

typedef const struct
{
    char *pcCommand;                                // Command String
    unsigned short (*pfInit) (char *pcParmStr);     // Pointer to Init-Function
    unsigned short (*pfChange) (void);
    unsigned short (*pfSendString) (char *pcOutputString);
    unsigned short (*pfPureSend) (char *pcOutputString);
    unsigned short (*pfReceiveString) (char *pcReceiveString);
} TCI_CHANNEL;

/*--------------------------------------------------------------------------------------*/
/*  global array with Command-strings and Functions of communication modules            */
/*--------------------------------------------------------------------------------------*/
extern TCI_CHANNEL asTciChannelList[];

/*--------------------------------------------------------------------------------------*/
/*  global variable with number of actual active communication channel                  */
/*--------------------------------------------------------------------------------------*/
extern unsigned char ucTSFW_GlobalCom;

/*--------------------------------------------------------------------------------------*/
/*  macro for output of a string with the active communication channel                  */
/*--------------------------------------------------------------------------------------*/
#define fTSFW_SEND_STRING(output_string)    (*(asTciChannelList[ucTSFW_GlobalCom].pfSendString)) (output_string)


#endif
