/****************************************************************************************/
/*                                                                                      */
/* File:        tsfw_sys.c               Version: 001                                   */
/*                                                                                      */
/* Author:      Gerhard Ort                                                             */
/*                                                                                      */
/* Language:    C                                                                       */
/*                                                                                      */
/* Description: module for definition of global variables which are mostly dependent    */
/*              from selections in T_SYST.H and semaphore functions for error setting   */
/*              and other system specific functions                                     */
/*                                                                                      */
/****************************************************************************************/
/*                                                                                      */
/* 12.07.99 V001 Gerhard Ort  File created                                              */
/* 14.02.04 C002 Volker Pritsching new format                                           */
/*                                                                                      */
/****************************************************************************************/
/****************************************************************************************/
/* Imports                                                                              */
/****************************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
// for definition of global constants in this source file (look in t_syst.h)
#define TSFW_SYS_SOURCE
#include "SystemGlobals.h"
/****************************************************************************************/
/* Exports                                                                              */
/****************************************************************************************/
/*--------------------------------------------------------------------------------------*\
 *  global buffer for return of functions, also error messages
 *  can be used within SCPI-functions
\*--------------------------------------------------------------------------------------*/
char tMSG_Buffer[COM_STRLEN_MAX+1];     // COM_STRLEN_MAX is defined in T_SYST.H

/*--------------------------------------------------------------------------------------*\
 *  pointer to the return-message of functions, also error messages
\*--------------------------------------------------------------------------------------*/
char *pcReturn;
/*--------------------------------------------------------------------------------------*\
 *  Testsoftware variables, which length dependents on changeable constants
 *  this arrays can't be defined in a source file, which should be linked to a library
 *  so the variables are declared extern in the Library and are defined here
 *  -> Tsfw_sys.c should not be placed in a library, when the constants (in t_syst.h)
 *     should be changed after library creation!!
\*--------------------------------------------------------------------------------------*/
// don't change
// used in TSFW_SCI.C
char tTSFW_SCI_Error_String[COM_STRLEN_MAX+1];
char tTSFW_SCI_CommandInterpreter_String[COM_STRLEN_MAX+3+1+MAX_0_00_REPLACE];
unsigned char ucTSFW_CAN_Task_started=0;
/****************************************************************************************/
/* Locals                                                                               */
/****************************************************************************************/
// flags helping Assert-Functions to set only once an error:
static volatile unsigned char aucTSFW_SciSecurityFlags[2] = {0,0};
static volatile unsigned char aucAssertSecurityFlags[2] = {0,0};
/****************************************************************************************/
/*  Functions                                                                           */
/****************************************************************************************/

/****************************************************************************************/
/*                                                                                      */
/* Function   : fTSFW_ErrorCanBeSet                                                     */
/*                                                                                      */
/* Description: Semaphore function, returns 1, if a error can be set, if it was not set */
/*              before                                                                  */
/*              used from fSetError (0) in t_asrc/tsfw_sci.c and from Assert functions  */
/*              (1) in t_asrc/tsfw_sci.                                                 */
/*                                                                                      */
/* Return     : 0 -> error was set before                                               */
/*              1 -> error was not set before, but is set now                           */
/*                                                                                      */
/****************************************************************************************/
unsigned char fTSFW_ErrorCanBeSet
(
  unsigned char ucSemaphoreNumber       // IMP: number of semaphore 0 or 1
){
if(ucSemaphoreNumber == 0)  {
  // set only once an error:
  if(aucTSFW_SciSecurityFlags[0]) return 0;
  aucTSFW_SciSecurityFlags[0] = 1;
  if(aucTSFW_SciSecurityFlags[1]) return 0;
  aucTSFW_SciSecurityFlags[1] = 1;
  return 1;
  }
else {
  // set only once an error:
  if(aucAssertSecurityFlags[0]) return 0;
  aucAssertSecurityFlags[0] = 1;
  if(aucAssertSecurityFlags[1]) return 0;
  aucAssertSecurityFlags[1] = 1;
  return 1;
  }
}
/****************************************************************************************/
/*                                                                                      */
/* Function   : fTSFW_ResetErrorSemaphore                                               */
/*                                                                                      */
/* Description: Releases a Semaphore                                                    */
/*                                                                                      */
/* Return     : none                                                                    */
/*                                                                                      */
/****************************************************************************************/
void fTSFW_ResetErrorSemaphore
(
  unsigned char ucSemaphoreNumber       // IMP: number of semaphore 0 or 1
){
if(ucSemaphoreNumber == 0){
  aucTSFW_SciSecurityFlags[1] = 0;
  aucTSFW_SciSecurityFlags[0] = 0;
  }
else{
  aucAssertSecurityFlags[1] = 0;
  aucAssertSecurityFlags[0] = 0;
  }
}
/****************************************************************************************/
/*                                                                                      */
/* Function   : fMakeStringReady4sscanf()                                               */
/*                                                                                      */
/* Description: Replaces in pcPara single '0' with "00", but only ucMAX_0_00_REPLACE    */
/*              '0'-Parameters will be replaced; ucMAX_0_00_REPLACE is a constant and   */
/*              can be changed in t_syst.h                                              */
/*              2 extra end signs '\0' are added behind the string                      */
/*              the string have to deliver the necessary space for these changes        */
/*                                                                                      */
/* Return     : pointer to the string (same as given)                                   */
/*                                                                                      */
/****************************************************************************************/
char *fMakeStringReady4sscanf
(
  char          *pcPara     // I/E: String to work with
){
char *pcTemp, *pcLast;
unsigned char ucZero_Count=0;
char c, cBefore = ' ';
// read string len and number of single 0-Parameter
pcTemp = pcPara;
while((c=*pcTemp)) {
  if(ucZero_Count < ucMAX_0_00_REPLACE) {
    if(c == '0' && cBefore == ' ' && (pcTemp[1] == ' ' || pcTemp[1] == '\0')){
      pcLast = pcTemp;
      ucZero_Count++;
      }
    cBefore = c;
    pcTemp++;
    }
  else while(*++pcTemp); // count only the characters
  }
// add 2 extra end signs to string
pcTemp[ucZero_Count+1] = '\0';
pcTemp[ucZero_Count+2] = '\0';
// replace single 0 with "00"
while(ucZero_Count) {
  // move last characters to make free space for extra '0'
  do {
    pcTemp[ucZero_Count] = *pcTemp;
    pcTemp--;
    }while(pcTemp > pcLast);
  pcTemp[ucZero_Count] = '0';
  ucZero_Count--;
  if(ucZero_Count) {
    pcTemp[ucZero_Count] = '0';
    pcTemp--;
    // search next '0' parameter
    cBefore = ' ';
    pcLast = pcTemp - 1;
    while(1) {
      c = *pcLast;
      if(c == '0' && cBefore == ' ' && (pcLast == pcPara || pcLast[-1] == ' ')) break;
      else {
        cBefore = c;
        pcLast--;
        }
      }
    }
  }
return pcPara;
}
#ifndef fStrStr     // look in Coretsfw.h for this definition
/****************************************************************************************/
/*                                                                                      */
/* Function   : fStrStr()                                                               */
/*                                                                                      */
/* Description: standard ANSI-strstr-function, which is not supported by the compiler:  */
/*              search in s1 for s2                                                     */
/*              check in Compiler-Updates if this function is available (string.h)      */
/*                                                                                      */
/* Return     : pointer to first placement of s2 in s1 or NULL if s2 was not found      */
/*                                                                                      */
/****************************************************************************************/
char *fStrStr
(
  const char *s1,              // string to search in
  const char *s2               // string to search for
){
char *pcTemp1,*pcTemp2;
if(s1==NULL || s2==NULL) return NULL;   // fault: searching in or for NULL-String
  do {
    pcTemp2=(char *)s2+1;
    // search for first character
    while(*s1!=*s2 && *s1!='\0') s1++;
    if(*s1!='\0')  {
      // first character found, check the others
      pcTemp1=(char *)s1+1;
      while(*pcTemp1==*pcTemp2 && *pcTemp2!='\0' && *pcTemp1!='\0'){
        pcTemp1++;
        pcTemp2++;
        }
      if(*pcTemp2=='\0') return (char *)s1;     // found, ready
      else s1++; // it was not the whole s2 found go to next position to check
      }
    else if(*s2=='\0') return (char *)s1;  // searching for "" OK
    }
  while(*s1!='\0');
  return NULL;
}
#endif
