/****************************************************************************************/
/*                                                                                      */
/* Name       : SSI.h          Version: 002.020221go                               */
/*                                                                                      */
/* Author     : Gerhard Ort                                                             */
/*                                                                                      */
/* Language   : C                                                                       */
/*                                                                                      */
/* Description: Include File of the TSFW Command Interpreter                            */
/*              based on BIST_SCI.H from BIST_Software for mcb2, STATE004               */
/*                                                                                      */
/****************************************************************************************/
/*                                                                                      */
/* 16.09.98 V001 Gerhard Ort File created                                               */
/* 26.10.98 V002 Gerhard Ort Task numbers for Serial Communication added                */
/*                                                                                      */
/****************************************************************************************/


/*--------------------------------------------------------------------------------------*/
/* include control                                                                      */
/*--------------------------------------------------------------------------------------*/
#ifndef __INC_SystemSerialInterface
#define __INC_SystemSerialInterface


/****************************************************************************************/
/* Imports                                                                              */
/****************************************************************************************/
#include "SystemGlobals.h"


/****************************************************************************************/
/* Exports                                                                              */
/****************************************************************************************/

// global Flag, if Testsoftware has been started, modules and the active communication
// channel are init (when ready: 1)
extern unsigned char ucTSFW_Init_Ready;

/*--------------------------------------------------------------------------------------*/
/* function prototypes                                                                  */
/*--------------------------------------------------------------------------------------*/

/****************************************************************************************/
/*                                                                                      */
/* Function   : fTSFW_InitPCB()                                                         */
/*                                                                                      */
/* Description: Calls all init fuctions of the modules, calls nothing on further calls  */
/*                                                                                      */
/* Return     : none                                                                    */
/*                                                                                      */
/****************************************************************************************/
void fTSFW_InitPCB (void);

/****************************************************************************************/
/*                                                                                      */
/* Function   : fTSFW_CommandInterpreter()                                              */
/*                                                                                      */
/* Description: function, receives one command from communication channel, calls the    */
/*              TS-FW function and outputs answers                                      */
/*                                                                                      */
/* Return     : 0: O.K. (command executed or there was no command to execute)           */
/*              !=0: Error from communication channel                                   */
/*                                                                                      */
/****************************************************************************************/
unsigned short fTSFW_CommandInterpreter (void);

/*--------------------------------------------------------------------------------------*/
/* reentrant functions (must be declared on mcb2)                                       */
/*--------------------------------------------------------------------------------------*/

/****************************************************************************************/
/*                                                                                      */
/* Function   : fToUpperCase()                                                          */
/*                                                                                      */
/* Description: converts all characters of a string to uppercase                        */
/*                                                                                      */
/* Return     : none                                                                    */
/*                                                                                      */
/****************************************************************************************/
#ifdef T_MCB2
void fToUpperCase (char *pc) compact reentrant;
#else
void fToUpperCase (char *pc);
#endif

#endif /* __INCSSI */

