/****************************************************************************************/
/*                                                                                      */
/* Name       : CORETSFW.h          Version: 001.020222go                               */
/*                                                                                      */
/* Author     : Gerhard Ort                                                             */
/*              Volker Pritsching                                                       */
/* Language   : C                                                                       */
/*                                                                                      */
/* Description: Include File of CORETSFW.C module                                       */
/*              based on COREBIST.H from BIST_Software for mcb2, STATE004               */
/*                                                                                      */
/****************************************************************************************/
/*                                                                                      */
/* 16.09.98 V001 Gerhard Ort File created                                               */
/* 02.04.04 V002 mofified for fujitsu familie                                           */
/*                                                                                      */
/****************************************************************************************/

/*--------------------------------------------------------------------------------------*/
/* include control                                                                      */
/*--------------------------------------------------------------------------------------*/
#ifndef __INC_SystemCore
#define __INC_SystemCore


/****************************************************************************************/
/* Imports                                                                              */
/****************************************************************************************/
#include "SystemGlobals.h"
#include "SystemSerialInterface.h"

/****************************************************************************************/
/* Exports                                                                              */
/****************************************************************************************/

typedef const struct
{
    char *pcCommand;                                // Command String
    unsigned short (*callfunc) (char *pcParmStr);   // Pointer to function
} COM_DEF;

typedef const struct {
    COM_DEF *pasComDef;
    const char *pcModulName;
} COM_DEF_LIST;

extern COM_DEF_LIST asComDefList[];


/*--------------------------------------------------------------------------------------*/
/* Konstants and Macros                                                                 */
/*--------------------------------------------------------------------------------------*/
#define FALSE 0
#define TRUE  1

/*--------------------------------------------------------------------------------------*/
/* Macro RETURN should be used by Command- and Query- Functions                         */
/*--------------------------------------------------------------------------------------*/
#define RETURN(number, message)     return (pcReturn=(message),(number))

/*--------------------------------------------------------------------------------------*/
/* Macros for accessing XRAM or memory-mapped-I/O                                       */
/*--------------------------------------------------------------------------------------*/
#define pucXRAM(BYTEADR) ((volatile unsigned char T_MEMPOINTER_KIND *) (BYTEADR))
#define pcXRAM(BYTEADR) ((volatile signed char T_MEMPOINTER_KIND *) (BYTEADR))
#define pushXRAM(WORDADR) ((volatile unsigned short T_MEMPOINTER_KIND *) (WORDADR))
#define pshXRAM(WORDADR) ((volatile signed short T_MEMPOINTER_KIND *) (WORDADR))

/*--------------------------------------------------------------------------------------*/
/* Macros for Bitmanipulation and for Checking, if Bit is 1                             */
/*--------------------------------------------------------------------------------------*/
#define SET_BIT(VAR,BITNR) ((VAR)|=1<<(BITNR))
#define RESET_BIT(VAR,BITNR) ((VAR)&=~(1<<(BITNR)))
#define SET_BIT2VALUE(VAR,BITNR,VALUE)  \
            if(VALUE)                   \
                SET_BIT(VAR,BITNR);     \
            else                        \
                RESET_BIT(VAR,BITNR)
#define IS_BIT1(VAR,BITNR) ((VAR)&(1<<(BITNR)))

/*--------------------------------------------------------------------------------------*/
/* Macros to disable/enable all Interrupts; for use in command sequences, which should  */
/* not be disturbed                                                                     */
/*--------------------------------------------------------------------------------------*/
#ifndef INTERRUPT_OFF
#define INTERRUPT_OFF ;__DI();
#define INTERRUPT_ON ;__EI();
#endif
/*--------------------------------------------------------------------------------------*/
/* SCPI-Interface variables                                                             */
/*--------------------------------------------------------------------------------------*/

//extern COM_DEF (* apasComDefList [])[];

extern const char *IDN_STRING;

extern void (*apfInitFuncList[]) (void);

extern void (*apfStatusOutputFunctionList[]) (unsigned short ushStatus);

extern void (*apfBufferClearanceFunctionList[]) (void);

/*--------------------------------------------------------------------------------------*/
/*  global buffer for messages, return of functions, also error messages                */
/*--------------------------------------------------------------------------------------*/
extern char tMSG_Buffer[COM_STRLEN_MAX+1];
extern unsigned int uiCounterFlux;
extern char *pcReturn;

/*--------------------------------------------------------------------------------------*/
/* special functions (defined in TSFW_SYS.C)                                            */
/*--------------------------------------------------------------------------------------*/
/****************************************************************************************/
/*                                                                                      */
/* Function   : fMakeStringReady4sscanf()                                               */
/*                                                                                      */
/* Description: Replaces in pcPara single '0' with "00", but only ucMAX_0_00_REPLACE    */
/*              '0'-Parameters will be replaced; ucMAX_0_00_REPLACE is a constant and   */
/*              can be changed in t_syst.h                                              */
/*              2 extra end signs '\0' are added behind the string                      */
/*              the string have to deliver the necessary space for these changes        */
/*                                                                                      */
/* Return     : pointer to the string (same as given)                                   */
/*                                                                                      */
/****************************************************************************************/
char *fMakeStringReady4sscanf
(
  char          *pcPara     // I/E: String to work with
);

// check if the function strstr is available in string.h
#if 1   // 1 if strstr is defined in string.h - 0 if strstr is not defined in string.h
#include <string.h>
#define fStrStr strstr  // use strstr instead of fStrStr
#else
/****************************************************************************************/
/*                                                                                      */
/* Function   : fStrStr()                                                               */
/*                                                                                      */
/* Description: standard ANSI-strstr-function, which is not supported by the compiler:  */
/*              search in s1 for s2                                                     */
/*              check in Compiler-Updates if this function is available (string.h)      */
/*                                                                                      */
/* Return     : pointer to first placement of s2 in s1 or NULL if s2 was not found      */
/*                                                                                      */
/****************************************************************************************/
char *fStrStr(const char *s1, const char *s2);
#endif

#endif

