/********************************************************************/
/*                                                                  */
/* Name       : ATmega128_tsfw.c          Version: 001.vpr            */
/*                                                                  */
/* Author     : Volker Pritsching                                   */
/* template   : by Gerhard Ort                                      */
/*                                                                  */
/* Language   : C                                                   */
/*                                                                  */
/* Description: FW template                                         */
/*              Standard Fujitsu functions                          */
/*                                                                  */
/*                                                                  */
/********************************************************************/
/*                                                                  */
/* 14.4.07 V001
      http://www.roboternetz.de/wissen/index.php/RC5-Decoder_f%C3%BCr_ATMega  */
/*               from BIST_Software for mcb2, STATE004              */
/* 14.04.07 V001 Volker Pritsching angepasst an die testsoftware    */
/********************************************************************/


/********************************************************************/
/* Imports                                                          */
/********************************************************************/
#include <stdio.h>
#include <string.h>

#include <avr/io.h>
#include <avr/interrupt.h>

#include <SystemSerialInterface.h>

#include "ATMEGA_RC5.h"

/* ******************************************************************************** */ 

rc5_t rc5; 

/* ******************************************************************************** */ 

#define setBit(Port,Bit) Port |= (1<< Bit)
#define clrBit(Port,Bit) Port &= ~(1<< Bit)
#define cplBit(Port,Bit) Port ^= (1<< Bit)
//F:CPU = 4mhz
#define RC5_PRESCALE 64  //256
#define RC5_BIT_US   1728           //(64*27) 
#define RC5_TICKS  108 //27              
//         ((uint8_t) ((uint32_t) (F_CPU / 1000 * RC5_BIT_US / 1000 / RC5_PRESCALE))) 
#define RC5_DELTA (RC5_TICKS / 6) 

typedef union { 
   unsigned int w; 
   unsigned char ucB[2];
   } code_t; 
   
static code_t Code; 
static unsigned char ucRC5Addr; 

static unsigned char ucBits; 
static unsigned char ucInts; 
unsigned char ucRC5TimerEnable;
unsigned char ucRC5PreTimer;
unsigned char ucRC5TC;
extern unsigned char ucSoftPrescalar;
extern unsigned char ucRC5Timer;

/* ******************************************************************************** */ 
void rc5_init (unsigned char ucAddr) { 

  ucRC5Timer =0,
  ucInts = 0; 
  ucBits = 0; 
  rc5.cStatus = -1; 
  ucRC5Addr = ucAddr;
  ucRC5TimerEnable = 0;
  MCUCR = (MCUCR | (1 << ISC01)) & ~ (1 << ISC00); 
  GIFR = (1 << INTF0); 
  GICR |= (1 << INT0); 
}



/* ******************************************************************************** */ 
void TIMER_RC5(void){

  code_t iCode;
  unsigned char uciBits;
  unsigned char uciRC5Code;
  unsigned char uciRC5Addr;
  char cStatus;

  ucRC5TimerEnable =0;                         // disable Timmerfunction RC5 Code


        
  uciBits = ucBits;
  iCode = Code;
  if (uciBits == 26 ) {
     uciBits++;
     iCode.w <<= 1;
     }
  if ((uciBits ==27) && (iCode.ucB[1] >= 0x30) && (rc5.cStatus < 0)){
     uciRC5Code = iCode.ucB[0] & 0x3f; /* 0b00111111 : #0..#5 */
     iCode.w <<= 2;
     uciRC5Addr = iCode.ucB[1] & 0x1f; /* 0b00011111 : #6..#10 */
     if ((ucRC5Addr & 0x80 ) || (ucRC5Addr == uciRC5Addr)) {
        rc5.ucCode = uciRC5Code;
        rc5.ucAddr = uciRC5Addr;
        cStatus = 0;
        if (iCode.ucB[1] & 0x20) cStatus = 1;
        rc5.cStatus = cStatus;
      }
    }
    ucInts = 0;
    ucBits = 0;
    MCUCR = (MCUCR | (1 << ISC01)) & ~ (1 << ISC00);
    GIFR = (1 << INTF0);
    GICR |= (1 << INT0);
  
}
unsigned char ucLast;
unsigned int uiCon;
/* ******************************************************************************** */ 

ISR (INT0_vect) {


code_t iCode;
unsigned char uciInts;
unsigned char n, uciBits;
unsigned char tcnt0;

   iCode = Code;
   uciInts = ucInts;
   tcnt0 =  TCNT0;                       // Zhlerstand Timer 0
   TCNT0 = 0;

   if (uciInts == 0){
        MCUCR = (MCUCR | (1 << ISC00)) & ~ (1 << ISC01); //  INTx on both edges 
		ucRC5TimerEnable = 1;
		iCode.w=0;
        }
   else {
        n =1;
		uciBits = ucBits;    
        if (tcnt0 > RC5_TICKS + RC5_DELTA) {             // is TCNT0 close to RC5_TICKS or RC5_TICKS/2 ? 
            uciBits = 0;
		    GICR &= ~(1 << INT0);                        // disable INTx, run into Overflow0 
			}       
        else if (tcnt0 < RC5_TICKS/2 - RC5_DELTA){
              uciBits = 0;
		      GICR &= ~(1 << INT0);                        // disable INTx, run into Overflow0 
			  }       
        else if (tcnt0 > RC5_TICKS - RC5_DELTA)
              n = 2;
        else if (tcnt0 > RC5_TICKS/2 + RC5_DELTA){
              uciBits = 0;
		      GICR &= ~(1 << INT0);                      // disable INTx, run into Overflow0 
			  }       
        do {                                             // store the just received 1 or 2 bits 
           uciBits++;
           if (uciBits & 1) {
		      iCode.w <<= 1;
              iCode.ucB[0] |= uciInts & 1;
              }
            } while (--n);
        ucBits = uciBits;
        }
  Code = iCode;
  ucInts = uciInts+1;
}
